
#include <string.h>
#include "kernel.h"
#include "kernel_id.h"
#include "ecrobot_interface.h"
#include "power_meter.h"

static U8 v0 = 0;
static U8 v1 = 0;

void Pmr_init(int port){
	ecrobot_init_i2c(port , LOWSPEED);
}

void Pmr_adc(int port)
{
	static U8 data[2] = {0};

//	ecrobot_read_i2c(port , 0x90>>1 , 0x04, data , 1);
	ecrobot_read_i2c(port , 0x90>>1 , 0x00, data , 1);
	v0 = data[0];
	ecrobot_read_i2c(port , 0x90>>1 , 0x01, data , 1);
	v1 = data[0];

}
U8 Pmr_get_v0()
{
	return v0;
}
U8 Pmr_get_v1()
{
	return v1;
}
