#include <string.h>
#include "kernel.h"
#include "kernel_id.h"
#include "ecrobot_interface.h"
#include "nxt.h"

static int black_value ;
static int white_value;
static int threshold;

//NXTNX

void Nxt_init(){
	black_value = 0;
	white_value = 0;
	threshold   = 0;
}		
boolean Nxt_isEnterKey(){
	if (0 != ecrobot_is_ENTER_button_pressed()){
		return true;
	}else {
		return false;
	}
	return false;
}
void Nxt_set_black_value(int val){
	black_value = val;
}
void Nxt_set_white_value(int val){
	white_value = val;
}
void Nxt_calc_threshold(void){
	threshold = (white_value + black_value) / 2;
}
boolean Nxt_isWhite(int val){
	if (val < threshold){
		return true;
	}else{
		return false;
	}
	return false;
}
boolean Nxt_isBlack(int val){
	if (val > threshold){
		return true;
	}else{
		return false;
	}
	return false;
}
int Nxt_get_threshold_value(){
	return threshold;
}
int Nxt_get_black_value()
{
	return black_value;	
}
int Nxt_get_white_value()
{
	return white_value;	
}
