extern "C" {
#include <string.h>
#include "kernel.h"
#include "kernel_id.h"
#include "ecrobot_interface.h"
}
#include "getc2011_define.h"
#include "handler.h"
#include "timer_controller.h"

TimerController::TimerController(){
	counter = 0;
	for (int i = 0 ; i < MAX_OBJECT ; i++){
		object[i] = (Handler*)null;
	}
}
	
void TimerController::regist_timer_event(Handler *obj,int timer){//timer=msec order
	if (MAX_OBJECT > counter){
		obj->init_counter = timer; // set timer counter
		obj->timer_counter = timer; // set timer counter
		obj->registed_number = counter;//o^ꂽԍ
		object[counter++] = obj;    // set AIuWFNg
	}
}
void TimerController::timer_interrupt(){
	Handler *obj;
	for ( int i = 0 ; i < MAX_OBJECT ; i++){
			obj = object[i];
		if (null != obj){
			obj->timer_counter -= REDUCE_TIME; //10msec reduce
			if (0 >= obj->timer_counter){
				obj->timer_handler();
				obj->timer_counter = obj->init_counter; //lɖ߂
			} 
		}
	}
}
