
extern "C" {
#include <string.h>
#include "kernel.h"
#include "kernel_id.h"
#include "ecrobot_interface.h"
}

#include "getc2011_define.h"
#include "handler.h"
#include "event_controller.h"
#include "timer_controller.h"
#include "nxt.h"
#include "motor.h"
#include "motor_controller.h"
#include "sensor.h"
#include "sonar.h"
#include "bluetooth.h"
#include "display.h"
#include "battery.h"
#include "pc_manager.h"
#include "manager.h"


Manager::Manager(){
	timer_controller= new TimerController();
	event_controller= new EventController();
	left_sensor		= new Sensor(NXT_PORT_S1);//ZT;
	right_sensor	= new Sensor(NXT_PORT_S2);//EZT;
	light_sensor	= new Sensor(NXT_PORT_S3);//ZT;
	left_motor		= new Motor(NXT_PORT_B);   //[^;
	right_motor		= new Motor(NXT_PORT_A);  //E[^;
	sonar			= new Sonar(NXT_PORT_S4);  //\i[;
	bluetooth_slave = new BlueTooth();        //BlueTooth
	disp			= new Display();          //LCD
	batt			= new Battery();          //obe[
	mc				= new MotorController();  //[^Rg[
	pm				= new PcManager();        //PCƂ̒ʐM
	nxt				= new Nxt();              //NXT
}

void Manager::timer_interrupt(){
    if (0 == (reduce_counter++ % REDUCE_TIME))//REDUCE_TIMEƂɔs
    {
		if (null != timer_controller){
			timer_controller->timer_interrupt();//^C}[sʒm
		}
	}
}	
void Manager::init(){
	reduce_counter = 0;
	counter  = 0;
	left_val = 0;
	right_val = 0;
	light_val = 0;
	batt_val = 0;
	
	left_sensor->init();
	right_sensor->init();
	light_sensor->init();
	left_motor->init();
	right_motor->init();
	sonar->init();
	disp -> init();
	batt->init();
	mc->init(0 , left_motor , right_motor);
	pm->init(bluetooth_slave,event_controller,nxt,light_sensor);
	nxt->init();
	

	//pmɑ΂PM_INTERVAL_TIMEPʂtimer_handler()ĂԂ悤ɓo^
	timer_controller->regist_timer_event((Handler*) pm  , PM_INTERVAL_TIME);
	
	//mcɑ΂REDUCE_TIMEPʂevent_handler()ĂԂ悤ɓo^
	event_controller->regist_event((Handler*)mc);
}

void Manager::carlibration(){
	//̂߂̃Lu[V

	disp->clear();
	disp->xy_string(0,0,"Put on Black\n");
	disp->xy_string(0,1,"Push ENTER button\n");
	display_update();
	while (1){
		nxt->set_black_value(light_sensor->read_data());
		if (nxt->isEnterKey())//IW{^ꂽH
		{
			break; 
		}
		
	}
	disp->clear();
	disp->xy_int(0 , 0 , "Black value: "  , nxt->get_black_value() , 0);
	display_update();

	systick_wait_ms(1000); 

	//Lu[V

	disp->clear();
	disp->xy_string(0,0,"Put on White\n");
	disp->xy_string(0,1,"Push ENTER button\n");
	display_update();
	while (1){
		nxt->set_white_value(light_sensor->read_data());
		if (nxt->isEnterKey())//IW{^ꂽH
		{
			break; 
		}
		
	}
	
	//XbVȟvZ
	nxt->calc_threshold();

	systick_wait_ms(1000); 

	//S̒l\
	disp->clear();
	disp->xy_int(0 , 0 , "Black value: "  , nxt->get_black_value() , 0);
	disp->xy_int(0 , 1 , "White value: "  , nxt->get_white_value() , 0);
	disp->xy_int(0 , 2 , "Th    value: "  , nxt->get_threshold_value() , 0);
	disp->xy_string(0 , 4 , "BT Waiting\n ");
	display_update();

	bluetooth_slave->wait_connect(); //ڑ܂ő҂

	disp->clear();
	disp->xy_string(0,0,"BT Connected!\n ");
	disp->update();
}

void Manager::loop(){
	counter = 0;
  
	while(1) {
		left_val  = left_sensor->read_data();
		right_val = right_sensor->read_data();
		light_val = light_sensor->read_data();
		batt_val  = batt->get_voltage();
		pid = (int)mc->pid(left_val , (left_val + right_val)/2);
		mc->turn(-pid);
    
		if ( 0 == (counter++ % 100)){

			int i=0;
			disp->clear();
			disp->xy_int(0 , i++ , "Left: "  , left_val , 0);
			disp->xy_int(0 , i++ , "Right: " , right_val , 0);
			disp->xy_int(0 , i++ , "Light: " , light_val, 0);
			disp->xy_int(0 , i++ , "Batt: "  , batt_val  , 0);
			disp->xy_int(0 , i++ , "pid: "   , pid             , 0);
			display_goto_xy(0, i++);
		
			disp->update();
		}
		systick_wait_ms(5);
  	}
}


