extern "C" {
#include <string.h>
#include "kernel.h"
#include "kernel_id.h"
#include "ecrobot_interface.h"
}
#include "getc2011_define.h"
#include "bluetooth.h"


BlueTooth::BlueTooth(){}
BlueTooth::~BlueTooth(){
	disconnect(); 
}
void BlueTooth::init_slave(char *str){
	ecrobot_init_bt_slave(str);//BlueTooth X[uݒ
}
SINT BlueTooth::send(U8 *data , U32 len){
	return ecrobot_send_bt_packet (data,len);
}
SINT BlueTooth::get_state(){
	return ecrobot_get_bt_status();
}
U32  BlueTooth::rec(U8 *data, U32 len){
	return ecrobot_read_bt_packet(data , len);
}
void BlueTooth::disconnect(){
	ecrobot_term_bt_connection();//BlueTooth I
}
boolean BlueTooth::wait_connect(){
	while (true){
		if (BT_STREAM == get_state()){
			break;
		}
		else {
			init_slave(BT_SLAVE);
			systick_wait_ms(10);
		}
	}
	ecrobot_get_bt_device_address(bt_address);
	
	//BlueToothAhX̉2.Ȃ݂[6]͏Ƀ[
	user_address[0] = bt_address[4];
	user_address[1] = bt_address[5];
	
	return true;
}
U8* BlueTooth::get_user_address(){
	return user_address;
}

