#ifndef __CLASS_MOTOR_CONTROLLER__
#define __CLASS_MOTOR_CONTROLLER__

// CLASS MotorController
//
// @class "MotorController" @param "-current:double,-previous:double,-integral:double,-kp:const double,-ki:const double,-kd:const double,-delta:const double,-left:Motor *,-right:Motor *,-foward:int,-state:int" @func "+init():void,+pid():double,+run():void,+stop():void,+turn ():void,+state_machine():void,+func_no_run_start():void,+func_no_run_stop():void,+func_run_start():void,+func_run_stop():void,+timer_handler():void,+event_handler():void" @extend "Handler"


class MotorController: Handler{
private:
	double current;
	double previous ;
	double integral;
	const double kp;   
	const double ki;   
	const double kd;   
	const double delta;

	Motor *left;
	Motor *right;
	int foward;
	int state;
	
public:
	MotorController();
	void init(int f, Motor *l , Motor *r);
	double pid(double sensor , double target);
	void run(int f);
	void stop();
	void turn (int tn);

	void state_machine(int event);
	void func_no_run_start();
	void func_no_run_stop ();
	void func_run_start();
	void func_run_stop ();
	void timer_handler();//Ȃ

	//Cxgnh[ŏԑ@ۃ}VĂяo
	void event_handler(int event) ;
};
#endif
